/****** Object:  StoredProcedure [hips].[MonitoringItemCounts]    Script Date: 07/11/2013 14:20:13 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MonitoringItemCounts]') AND type in (N'P', N'PC'))
DROP PROCEDURE [hips].[MonitoringItemCounts]
GO

/****** Object:  StoredProcedure [hips].[MonitoringItemCounts]    Script Date: 07/11/2013 14:20:13 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Description:   Get counts of items for the monitoring tool
--					
-- =============================================

CREATE PROCEDURE [hips].[MonitoringItemCounts] 
(
	@PcehrFailedDays INTEGER = 1,
	@MonitorHours INTEGER = 8,
	@PasRefreshMinutes INTEGER = 10,
	@IhiRefreshMinutes INTEGER = 60
)
AS
BEGIN

DECLARE @CDAUploaded INTEGER
DECLARE @PCEHRAdvertised INTEGER
DECLARE @MonitoringPcehrOldestPendingMinutes INTEGER
DECLARE @MonitoringRecentPcehrFailedCount INTEGER
DECLARE @MonitoringRecentPcehrPendingCount INTEGER
DECLARE @MonitoringPasErrorCount INTEGER
DECLARE @MonitoringIhiAverageTime DECIMAL(10,3)
DECLARE @MonitoringPcehrAverageTime DECIMAL(10,3)
DECLARE @MonitoringPasMessageCount INTEGER
DECLARE @MonitoringPatientCount INTEGER
DECLARE @MonitoringTotalMessages INTEGER
DECLARE @MonitoringUniqueIhiCount INTEGER
DECLARE @MonitoringIhiAlertCount INTEGER 

SET @CDAUploaded = 0
SET @PCEHRAdvertised = 0
SET @MonitoringPcehrOldestPendingMinutes = 0
SET @MonitoringRecentPcehrFailedCount = 0
SET @MonitoringRecentPcehrPendingCount = 0
SET @MonitoringPasErrorCount = 0
SET @MonitoringIhiAverageTime = 0.0000
SET @MonitoringPcehrAverageTime = 0.0000
SET @MonitoringPasMessageCount = 0
SET @MonitoringPatientCount = 0
SET @MonitoringTotalMessages = 0
SET @MonitoringUniqueIhiCount = 0
SET @MonitoringIhiAlertCount = 0


SELECT @CDAUploaded = COUNT(*) 
	FROM hips.ClinicalDocument  WITH (NOLOCK) 
	WHERE ClinicalDocumentStatusId = 1
 
SELECT @PCEHRAdvertised = COUNT(*) 
	FROM hips.HealthProviderOrganisationPatient  WITH (NOLOCK)
	WHERE PcehrAdvertised = 1 

SELECT @MonitoringPcehrOldestPendingMinutes = COALESCE(MAX(DATEDIFF(minute, DateCreated, GETDATE())), 0)
	FROM [hips].[PcehrMessageQueue]  WITH (NOLOCK)
	WHERE QueueStatusId = 1

SELECT @MonitoringRecentPcehrFailedCount = COUNT(*) 
	FROM hips.PcehrMessageQueue pmq WITH (NOLOCK)
	JOIN hips.Episode e WITH (NOLOCK) ON e.EpisodeId = pmq.EpisodeId
	LEFT JOIN hips.ClinicalDocument cd WITH (NOLOCK) ON cd.EpisodeId = e.EpisodeId
	LEFT JOIN hips.ClinicalDocumentVersion cdv WITH (NOLOCK) ON cd.ClinicalDocumentId = cdv.ClinicalDocumentId
	WHERE QueueStatusId = 3
	AND DATEDIFF(day, pmq.DateCreated, SYSDATETIME())<=7
	AND (cdv.UploadedDate IS NULL OR cdv.UploadedDate < pmq.DateCreated)

SELECT  @MonitoringRecentPcehrPendingCount = COUNT(*)  
	FROM  hips.PcehrMessageQueue WITH (NOLOCK)
	WHERE QueueStatusId = 1

SELECT @MonitoringPasErrorCount = COUNT(*) 
	FROM hips.[MonitoringSyslog]
		WHERE MonitorTabId = 1
		AND DATEDIFF(hour, DateCreated, SYSDATETIME())<=@MonitorHours


SELECT @MonitoringIhiAverageTime =  
	COALESCE(
	CAST((
		AVG(
		CAST(
			(DATEDIFF(millisecond, Request.value('declare namespace s="http://www.w3.org/2003/05/soap-envelope"; 
												  declare namespace h="http://ns.electronichealth.net.au/hi/xsd/common/CommonCoreElements/3.0"; 
												  (/s:Envelope/s:Header/h:timestamp/h:created)[1]', 'datetime'),
								   DATEADD(MINUTE, DATEDIFF(MINUTE, GETDATE(), GETUTCDATE()), DateCreated)))AS DECIMAL)/CAST(1000 AS DECIMAL))) AS DECIMAL(10,3)),0)
	FROM [hips].[IhiLookupAudit] WITH (NOLOCK)
	WHERE DATEDIFF(hour, DateCreated, SYSDATETIME())<=@MonitorHours


SELECT @MonitoringPcehrAverageTime= 
	COALESCE(
	CAST((
		AVG(
		CAST(
			(DATEDIFF(millisecond, Request.value('declare namespace s="http://www.w3.org/2003/05/soap-envelope"; 
												  declare namespace h="http://ns.electronichealth.net.au/pcehr/xsd/common/CommonCoreElements/1.0"; 
												  (/s:Envelope/s:Header/h:timestamp/h:created)[1]', 'datetime'),
								   DATEADD(MINUTE, DATEDIFF(MINUTE, GETDATE(), GETUTCDATE()), DateCreated)))AS DECIMAL)/CAST(1000 AS DECIMAL))) AS DECIMAL(10,3)),0)
	FROM [hips].[PcehrAudit] WITH (NOLOCK)
	WHERE DATEDIFF(hour, DateCreated, SYSDATETIME())<=@MonitorHours


SELECT @MonitoringPasMessageCount = COUNT(*)  
	FROM  hips.HL7MessageLog WITH (NOLOCK)
	WHERE DATEDIFF(minute, DateCreated, SYSDATETIME())<=@PasRefreshMinutes


SELECT @MonitoringPatientCount = COUNT(*)
	FROM hips.PatientMaster WITH (NOLOCK)


SELECT @MonitoringTotalMessages = COUNT(*)
	FROM hips.HL7MessageLog WITH (NOLOCK)
	WHERE (FailureReason IS NULL)


SELECT @MonitoringUniqueIhiCount = COUNT(DISTINCT Ihi)
	FROM hips.PatientMasterIhi WITH (NOLOCK)


SELECT @MonitoringIhiAlertCount = COUNT(*)
	FROM hips.[MonitoringSyslog]
	WHERE MonitorTabId = 3
	AND DATEDIFF(minute, DateCreated, SYSDATETIME())<=@IhiRefreshMinutes




SELECT	@CDAUploaded AS CDAUploaded, 
		@PCEHRAdvertised AS PCEHRAdvertised, 
		@MonitoringPcehrOldestPendingMinutes AS MonitoringPcehrOldestPendingMinutes,
		@MonitoringRecentPcehrFailedCount AS MonitoringRecentPcehrFailedCount,
		@MonitoringRecentPcehrPendingCount AS MonitoringRecentPcehrPendingCount,
		@MonitoringPasErrorCount AS MonitoringPasErrorCount,
		@MonitoringIhiAverageTime AS MonitoringIhiAverageTime,
		@MonitoringPcehrAverageTime AS MonitoringPcehrAverageTime,
		@MonitoringPasMessageCount AS MonitoringPasMessageCount,
		@MonitoringPatientCount AS MonitoringPatientCount,
		@MonitoringTotalMessages AS MonitoringTotalMessages,
		@MonitoringUniqueIhiCount AS MonitoringUniqueIhiCount,
		@MonitoringIhiAlertCount AS MonitoringIhiAlertCount

END

GO

